#!/usr/bin/perl
#
$Version = 0.01;
@ARGV = (	"../../release/product-eirma_ldm.xml", 
			"../codes", 
			"../phrases", 
			"../plugins", 
			"../templates"	);
#
# Extracts the installation codes, phrases, plugins and templates from $argv[0] and writes
# them as files into the other directories
#
# Usage : strip.pl xmlfile code_dir phrase_dir template_dir
#

$xml = shift @ARGV;
open XML , "<$xml" or die "Unable to open $xml";

$xml = "";
while (<XML>) {$xml .= $_;}

close XML;

# ---------------------------------------------------------------------------------
print "Gathering installation codes\n";
$outdir = shift @ARGV;
$outdir=~s/\\/\//g;
$outdir=~s/(.*)[ \/]+$/$1/;
while ($xml =~ m/([\ \t]*<code version="(.*?)">.*?<\/code>)/gs) {
    print "Found $2\n";
    open FILE , ">$outdir/$2.txt" or die "Unable to open $outdir/$2.txt";
    print FILE $1."\n";
    close FILE;
}

# ---------------------------------------------------------------------------------
print "Gathering phrases\n";
$outdir = shift @ARGV;
$outdir=~s/\\/\//g;
$outdir=~s/(.*)[ \/]+$/$1/;
while ($xml =~ m/<phrases>(.*?)<\/phrases>/gs) {
    print "Found Phrases\n";
    open FILE , ">$outdir/phrases_en.txt" or die "Unable to open $outdir/phrases_en.txt";
	print FILE <<EOF_1;
<?xml version="1.0" encoding="ISO-8859-1"?>

<language name="English (US)" vbversion="3.5.0" product="eirma_ldm" type="phrases">
EOF_1
    print FILE $1."\n";
	print FILE <<EOF_2;
</language>
EOF_2
    close FILE;
}

# ---------------------------------------------------------------------------------
print "Gathering plugins\n";
$outdir = shift @ARGV;
$outdir=~s/\\/\//g;
$outdir=~s/(.*)[ \/]+$/$1/;
while ($xml =~ m/([\ \t]*<plugins>.*?<\/plugins>)/gs) {
    print "Found Plugins\n";
    open FILE , ">$outdir/plugins.txt" or die "Unable to open $outdir/plugins.txt";
    print FILE $1."\n";
    close FILE;
}

# ---------------------------------------------------------------------------------
print "Gathering templates\n";
$outdir = shift @ARGV;
$outdir=~s/\\/\//g;
$outdir=~s/(.*)[ \/]+$/$1/;
while ($xml =~ m/([\ \t]*<template name=.(.*?). .*?><..CDATA.*?..><\/template>)/gs) {
    print "Found $2\n";
    open FILE , ">$outdir/$2.txt" or die "Unable to open $outdir/$2.txt";
    print FILE $1."\n";
    close FILE;
}